CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.columns  WHERE table_name= 'pdv_vd_vouchers'  and column_name='ativado' and data_type = 'boolean') THEN
						 
		--criado coluna auxiliar na tabela com o tipo desejado:
		ALTER TABLE pdv_vd_vouchers ADD COLUMN status_ativado integer not null default 0;
		--convertendo dados pr-existentes na coluna original para a coluna auxiliar de forma adequada:
		UPDATE pdv_vd_vouchers SET status_ativado = 0 WHERE ativado = FALSE;
		UPDATE pdv_vd_vouchers SET status_ativado = 2 WHERE ativado = TRUE;
		--Excluindo a coluna original:
		ALTER TABLE pdv_vd_vouchers DROP COLUMN ativado;
		--Renomeando a coluna status_ativado para o nome da coluna ativado:
		ALTER TABLE pdv_vd_vouchers RENAME COLUMN status_ativado TO ativado;						 
                         
        RAISE NOTICE 'Coluna "ativado" na tabela "pdv_vd_vouchers" Alterada com sucesso!' ;
        
    END if;
    
    				 
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();

 
